
const User = require("../../models/User");


// ----- user

exports.getUsers = async (req, res, next) => {
    const page = +req.query.page || 1;
    const limit = +req.query.size || 8;
    const offset = (page - 1) * limit;

    try {

        const users = await User.findAll({
            limit,
            offset,
            order: [
                ['id', 'DESC']
            ]
        });

        if (users.length == 0) {
            const error = new Error("هیچ کاربری در پایگاه داده ثبت نشده است");
            error.statusCode = 404;
            throw error;
        }

        const count = await User.count();
        const infoPage = {
            currentPage: page,
            nextPage: page + 1,
            previousPage: page - 1,
            hasNextPage: limit * page < count,
            hasPreviousPage: page > 1,
            pagesCount: Math.ceil(count / limit),
        }


        res.status(200).json({ items: users, count, infoPage });
    } catch (err) {
        next(err);
    }
};

exports.getUser = async (req, res, next) => {
    try {
        const user = await User.findByPk(req.params.id);
        if (!user) {
            const error = new Error("فردی با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        }
        res.status(200).json(user);
    } catch (err) {
        next(err);
    }
};

exports.addUser = async (req, res, next) => {
    try {
        const { phone, level } = req.body;
        const user = await User.findOne({ where: { phone } });
        if (user) {
            const error = new Error(
                "کاربری با این شماره در پایگاه داده موجود است"
            );
            error.statusCode = 422;
            throw error;
        } else {
            User.create({ phone, level });
            res.status(201).json({ message: "کاربر با موفقیت ساخته شد" });
        }
    } catch (err) {
        next(err);
    }
};

exports.editUser = async (req, res, next) => {
    try {
        const { fullname, email, level } = req.body;

        const user = await User.findOne({ where: { email } });

        if (!user) {
            const error = new Error(
                "کاربری با این ایمیل در پایگاه داده موجود نیست"
            );
            error.statusCode = 404;
            throw error;
        } else {
            if (fullname.length > 0) {
                user.fullname = fullname;
            }
            user.level = level;
            await user.save();
            next();
            res.status(200).json({ message: "کاربر با موفقیت ویرایش شد" });
        }
    } catch (err) {
        next(err);
    }
};
