const jwt = require("jsonwebtoken");
const bcrypt = require("bcryptjs");
const axios = require('axios');

const User = require("../../models/User.js");

const { schemaUser, schemaUserEdit, schemaLoginPhoneNumber, schemaPassword } = require("../../models/secure/userValidation.js");
const Link = require("../../models/Link.js");
const Menu = require("../../models/Menu.js");


let OTP_NUM;

// userCheck
exports.handleUserCheck = async (req, res, next) => {
    const { phone } = req.body;

    try {

        await schemaLoginPhoneNumber.validate({ phone }, { abortEarly: false });

        const user = await User.findOne({ where: { phone } });
        if (user && user.dataValues.password) {
            res.status(200).json({ phone, registered: true });
        } else {
            res.status(200).json({ phone, registered: false });
        }
    } catch (err) {
        next(err);
    }
};

// otp
exports.handleOtp = async (req, res, next) => {
    const { to } = req.body;
    const user = await User.findOne({ where: { phone: to } });
    Object.assign(req.body, { bodyId: 218270, args: ['arg1', 'arg2'] });
    try {
        const { data } = await axios.post(
            "https://console.melipayamak.com/api/send/otp/9387e188286741a9a10b6c2ad082a805",
            req.body
        );
        OTP_NUM = { phone: req.body.to, code: data.code };
        if (!user) {
            res.status(201).json({ message: data.status });
        } else {
            res.status(200).json({ message: data.status });
        }
    } catch (err) {
        next(err);
    }
};


// login

exports.handleLoginOtp = async (req, res, next) => {
    const { phone, code } = req.body;
    const usersCount = await User.count();
    try {
        if (phone === OTP_NUM.phone && code === OTP_NUM.code) {
            const user = await User.findOne({ where: { phone } });
            if (!user) {
                let token;
                if (usersCount > 0) {
                    let newUser = await User.create({ phone });
                    token = jwt.sign({
                        user: {
                            userId: newUser.id.toString(),
                            phone: phone,
                            level: "normal"
                        },
                    },
                        process.env.JWT_SECRET, {
                        expiresIn: "6h"
                    }
                    );
                } else {
                    let newUser = await User.create({ phone, level: "generalManager" });
                    token = jwt.sign({
                        user: {
                            userId: newUser.id.toString(),
                            phone: phone,
                            level: "generalManager"
                        },
                    },
                        process.env.JWT_SECRET, {
                        expiresIn: "2h"
                    }
                    );
                }
                res.status(201).json({ token, message: "عضویت موفقیت آمیز بود" });
            } else {
                const token = jwt.sign({
                    user: {
                        userId: user.id.toString(),
                        phone: user.phone,
                        level: user.level
                    },
                },
                    process.env.JWT_SECRET, {
                    expiresIn: "2h"
                }
                );
                res.status(200).json({ token, userId: user.id.toString() });
            }

        } else {
            const error = new Error("کد یکبار مصرف وارد شده معتبر نمی باشد");
            error.statusCode = 400;
            throw error;
        }

    } catch (err) {
        next(err);
    }
};

exports.handleLogin = async (req, res, next) => {
    const { phone, password } = req.body;

    try {

        await schemaPassword.validate({ phone, password }, { abortEarly: false });

        const user = await User.findOne({ where: { phone } });
        if (!user) {
            const error = new Error("کاربری با این شماره یافت نشد");
            error.statusCode = 404;
            throw error;
        }

        const isEqual = await bcrypt.compare(password, user.password);

        if (isEqual) {
            const token = jwt.sign({
                user: {
                    userId: user.id.toString(),
                    phone: user.phone,
                    fullname: user.fullname,
                    level: user.level
                },
            },
                process.env.JWT_SECRET, {
                expiresIn: "12h"
            }
            );
            res.status(200).json({ token, userId: user.id.toString() });
        } else {
            const error = new Error("شماره یا کلمه عبور اشتباه است");
            error.statusCode = 422;
            throw error;
        }
    } catch (err) {
        next(err);
    }
};

exports.handleLogOut = async (req, res, next) => {
    try {
        const user = await User.findOne({ where: { phone } });
        if (!user) {
            const error = new Error("کاربری با این شماره یافت نشد");
            error.statusCode = 404;
            throw error;
        }
        const isEqual = await bcrypt.compare(password, user.password);
        if (isEqual) {
            const token = jwt.sign({
                user: {
                    userId: user.id.toString(),
                    phone: user.phone,
                    fullname: user.fullname,
                    level: user.level
                },
            },
                process.env.JWT_SECRET, {
                expiresIn: "12h"
            }
            );
            res.status(200).json({ token, userId: user.id.toString() });
        } else {
            const error = new Error(" شماره یا کلمه عبور اشتباه است");
            error.statusCode = 422;
            throw error;
        }
    } catch (err) {
        next(err);
    }
};



// Password

exports.handleResetPassword = async (req, res, next) => {
    const authHeader = req.get("Authorization");
    const token = authHeader.split(" ")[1]; //Bearer Token => ['Bearer', token]

    const { password, confirmPassword } = req.body;

    try {
        const decodedToken = jwt.verify(token, process.env.JWT_SECRET);
        if (!decodedToken) {
            const error = new Error("شما مجوز این عملیات را ندارید");
            error.statusCode = 401;
            throw error;
        }

        if (password !== confirmPassword) {
            const error = new Error("کلمه های عبور یکسان نمی باشند");
            error.statusCode = 422;
            throw error;
        }

        const user = await User.findOne({ _id: decodedToken.userId });

        if (!user) {
            const error = new Error(
                "کاربری با این شناسه در پایگاه داده یافت نشد"
            );
            error.statusCode = 404;
            throw error;
        }


        await bcrypt.hash(password, 10, (err, hash) => {
            if (err) {
                return next(err)
            } else {
                user.password = hash;
                user.save();
            }
            next();
        });

        const createtoken = jwt.sign({
            user: {
                userId: user.id.toString(),
                phone: user.phone,
                fullname: user.fullname
            },
        },
            process.env.JWT_SECRET, {
            expiresIn: "2h"
        }
        );

        res.status(200).json({ createtoken, userId: user.id.toString(), message: "عملیات با موفقیت انجام شد" });
    } catch (err) {
        next(err);
    }
};

exports.editPassword = async (req, res, next) => {
    try {
        const { oldPassword, password, confirmPassword } = req.body;

        const user = await User.findByPk(req.userId);

        if (!user) {
            const error = new Error(
                "کاربری با این شماره در پایگاه داده موجود نیست"
            );
            error.statusCode = 404;
            throw error;
        }

        const isEqual = await bcrypt.compare(oldPassword, user.password);

        if (isEqual) {

            if (password !== confirmPassword) {
                const error = new Error("کلمه های عبور یکسان نمی باشند");
                error.statusCode = 422;
                throw error;
            }

            await bcrypt.hash(password, 10, (err, hash) => {
                if (err) {
                    return next(err)
                } else {
                    user.password = hash;
                    user.save();
                }
                next();
            });
            res.status(200).json({ message: "رمز عبور شما با موفقیت ویرایش شد" });
        } else {
            const error = new Error("کلمه عبور اشتباه است");
            error.statusCode = 422;
            throw error;
        }

    } catch (err) {
        next(err);
    }
};



// profile

exports.profile = async (req, res, next) => {
    try {

        const user = await User.findByPk(req.userId, {
            attributes: { exclude: ['password', 'updatedAt'] },
        });

        const link = await Link.count({ where: { userId: req.userId } })
        const menu = await Menu.count({ where: { userId: req.userId } })
        if (!user) {
            const error = new Error("کاربری با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        }

        res.status(200).json({ ...user.dataValues, link, menu });
    } catch (err) {
        next(err);
    }
};

exports.editUser = async (req, res, next) => {
    try {
        const { fullname } = req.body;

        const user = await User.findByPk(req.userId);

        if (!user) {
            const error = new Error(
                "کاربری با این شماره در پایگاه داده موجود نیست"
            );
            error.statusCode = 404;
            throw error;
        } else {

            await schemaUserEdit.validate({ fullname }, { abortEarly: false });
            user.fullname = fullname;
            await user.save();
            res.status(200).json({ message: "اطلاعات شما با موفقیت ویرایش شد" });

        }
    } catch (err) {
        next(err);
    }
};

exports.completeUser = async (req, res, next) => {
    try {
        const { fullname, password, confirmPassword } = req.body;

        const user = await User.findByPk(req.userId);

        if (!user) {
            const error = new Error(
                "کاربری با این شماره در پایگاه داده موجود نیست"
            );
            error.statusCode = 404;
            throw error;
        } else {

            await schemaUser.validate({ fullname, password, confirmPassword }, { abortEarly: false });

            await bcrypt.hash(password, 10, (err, hash) => {
                if (err) {
                    return next(err)
                } else {
                    user.fullname = fullname;
                    user.password = hash;
                    user.save();
                }
                next();
            });

            res.status(200).json({ message: "عضویت شما با موفقیت  تکمیل شد" });

        }
    } catch (err) {
        next(err);
    }
};