const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Link = require("./Link");
const Block = require("./Block");

const Banner = sequelize.define("Banner", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    image: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    linkAddress: {
        type: DataTypes.STRING,
        allowNull: true,
        defaultValue: ""
    },
    sort: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    blockId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Block,
            key: "id"
        }
    },
});

Banner.belongsTo(Block, { as: 'blocks', foreignKey: "blockId" })
Block.hasMany(Banner, { as: 'banners', foreignKey: "blockId" })



module.exports = Banner;