const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const M_MC = require("./M_MC");

const MenuItme = sequelize.define("MenuItme", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING("50"),
        allowNull: false,
    },
    description: {
        type: DataTypes.STRING("80"),
        allowNull: false,
    },
    price: {
        type: DataTypes.INTEGER("999999999"),
        allowNull: false,
    },
    discount: {
        type: DataTypes.INTEGER("100"),
        allowNull: false,
    },
    image: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    sort: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    active: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
    },
    categoryId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: M_MC,
            key: "id"
        }
    }
});

M_MC.hasMany(MenuItme, { foreignKey: "categoryId", as: "items" });
MenuItme.belongsTo(M_MC, { foreignKey: "categoryId", as: "category" });

module.exports = MenuItme;