const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");

const User = sequelize.define("User", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    fullname: {
        type: DataTypes.STRING("80"),
        allowNull: true,
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: false,
        // unique: true,
    },
    password: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    level: {
        type: DataTypes.ENUM("normal", "admin", "generalManager"),
        allowNull: false,
        defaultValue: "normal",
    }
});


module.exports = User;