const Yup = require("yup");


exports.schemaMenuPlan = Yup.object().shape({
    title: Yup.string()
        .required("عنوان پلن منو الزامی می باشد")
        .min(1, "عنوان آیتم منو نباید کمتر از 1 کاراکتر باشد")
        .max(255, "عنوان آیتم منو نباید بیشتر از 255 کاراکتر باشد"),
    day: Yup.number().required("تعداد روز پلن الزامی می باشد").min(1, "حداقل 1 روز می باشد").max(365, "حداکثر 365 روز می باشد"),
    price: Yup.string().required("قیمت پلن الزامی می باشد"),
    discount: Yup.number().required("قیمت پلن الزامی می باشد").min(0, "حداقل تخفیف 0 درصد می باشد").max(100, "حداکثر تخفیف 100 درصد می باشد"),
    publish: Yup.boolean("لطفا وضعیت انتشار پلن را تعیین کنید"),
});

exports.schemaWorkgroup = Yup.object().shape({
    title: Yup.string()
        .required("نام گروه کاری الزامی می باشد")
        .min(1, "نام گروه کاری نباید کمتر از 1 کاراکتر باشد")
        .max(255, "نام گروه کاری نباید بیشتر از 255 کاراکتر باشد"),
});

exports.schemaMenuCategory = Yup.object().shape({
    title: Yup.string()
        .required("عنوان دسته بندی منو الزامی می باشد")
        .min(1, "عنوان دسته بندی منو نباید کمتر از 1 کاراکتر باشد")
        .max(255, "عنوان دسته بندی منو نباید بیشتر از 255 کاراکتر باشد"),
    svg: Yup.string().required("تصویر دسته بندی الزامی می باشد"),
    workgroupId: Yup.number().required("گروه کاری الزامی می باشد"),
});

exports.schemaCreateMenu = Yup.object().shape({
    name: Yup.string()
        .required("نام منو الزامی می باشد")
        .min(1, "نام منو نباید کمتر از 1 کاراکتر باشد")
        .max(255, "نام منو نباید بیشتر از 255 کاراکتر باشد"),
    address: Yup.string()
        .required("آدرس مجازی منو الزامی می باشد")
        .min(1, "آدرس مجازی منو نباید کمتر از 1 کاراکتر باشد")
        .max(500, "آدرس مجازی منو نباید بیشتر از 500 کاراکتر باشد"),
    planId: Yup.number().required("پلن الزامی می باشد"),
});

exports.schemaExtensionMenu = Yup.object().shape({
    planId: Yup.number().required("پلن منو الزامی می باشد"),
    menuId: Yup.number().required("منو الزامی می باشد"),
});

exports.schemaEditMenu = Yup.object().shape({
    name: Yup.string()
        .required("نام منو الزامی می باشد")
        .min(1, "نام منو نباید کمتر از 1 کاراکتر باشد")
        .max(40, "نام منو نباید بیشتر از 40 کاراکتر باشد"),
    description: Yup.string()
        .required("توضیحات منو الزامی می باشد")
        .min(60, "توضیحات منو نباید کمتر از 60 کاراکتر باشد")
        .max(400, "توضیحات منو نباید بیشتر از 400 کاراکتر باشد"),
    logo: Yup.object().shape({
        name: Yup.string(),
        size: Yup.number().max(300000, "لوگو منو نباید بیشتر از 300 کیلوبایت باشد"), //500KB
        mimetype: Yup.mixed().oneOf(
            ["image/jpeg", "image/png"],
            "تنها پسوندهای png و jpeg پشتیبانی می شوند"
        ),
    }),
    image: Yup.object().shape({
        name: Yup.string(),
        size: Yup.number().max(500000, "تصویر منو نباید بیشتر از 500 کیلوبایت باشد"), //500KB
        mimetype: Yup.mixed().oneOf(
            ["image/jpeg", "image/png"],
            "تنها پسوندهای png و jpeg پشتیبانی می شوند"
        ),
    }),
    location: Yup.string()
        .required("آدرس محل الزامی می باشد")
        .min(1, "آدرس محل نباید کمتر از 1 کاراکتر باشد")
        .max(255, "آدرس محل نباید بیشتر از 255 کاراکتر باشد"),
    cityId: Yup.number().required("انتخاب شهر الزامی می باشد"),
    instagram: Yup.string()
        .required("آدرس اینستاگرام الزامی می باشد")
        .min(1, "آدرس اینستاگرام نباید کمتر از 1 کاراکتر باشد")
        .max(255, "آدرس اینستاگرام نباید بیشتر از 255 کاراکتر باشد"),
    phoneNumber: Yup.string()
        .required("شماره تلفن الزامی می باشد")
        .min(1, "آدرس اینستاگرام نباید کمتر از 1 کاراکتر باشد")
        .max(11, "آدرس اینستاگرام نباید بیشتر از 11 کاراکتر باشد"),
    workgroupId: Yup.number().required("گروه کاری الزامی می باشد"),
});


exports.schemaEditMenuInfo = Yup.object().shape({
    name: Yup.string()
        .required("نام منو الزامی می باشد")
        .min(1, "نام منو نباید کمتر از 1 کاراکتر باشد")
        .max(40, "نام منو نباید بیشتر از 40 کاراکتر باشد"),
    description: Yup.string()
        .required("توضیحات منو الزامی می باشد")
        .min(60, "توضیحات منو نباید کمتر از 60 کاراکتر باشد")
        .max(400, "توضیحات منو نباید بیشتر از 400 کاراکتر باشد"),
    logo: Yup.object().shape({
        name: Yup.string(),
        size: Yup.number().max(300000, "لوگو منو نباید بیشتر از 300 کیلوبایت باشد"), //500KB
        mimetype: Yup.mixed().oneOf(
            ["image/jpeg", "image/png"],
            "تنها پسوندهای png و jpeg پشتیبانی می شوند"
        ),
    }),
    image: Yup.object().shape({
        name: Yup.string(),
        size: Yup.number().max(500000, "تصویر منو نباید بیشتر از 500 کیلوبایت باشد"), //500KB
        mimetype: Yup.mixed().oneOf(
            ["image/jpeg", "image/png"],
            "تنها پسوندهای png و jpeg پشتیبانی می شوند"
        ),
    }),
    workgroupId: Yup.number().required("گروه کاری الزامی می باشد"),
});

exports.schemaEditMenuContact = Yup.object().shape({
    instagram: Yup.string()
        .min(1, "آدرس اینستاگرام نباید کمتر از 1 کاراکتر باشد")
        .max(255, "آدرس اینستاگرام نباید بیشتر از 255 کاراکتر باشد"),
    phoneNumber: Yup.string()
        .min(1, "آدرس اینستاگرام نباید کمتر از 1 کاراکتر باشد")
        .max(11, "آدرس اینستاگرام نباید بیشتر از 11 کاراکتر باشد"),
});

exports.schemaEditMenuLocation = Yup.object().shape({
    location: Yup.string()
        .required("آدرس محل الزامی می باشد")
        .min(1, "آدرس محل نباید کمتر از 1 کاراکتر باشد")
        .max(255, "آدرس محل نباید بیشتر از 255 کاراکتر باشد"),

});



exports.schemaEditMenuTheme = Yup.object().shape({
    colorTheme: Yup.string().required("رنگ قالب الزامی می باشد"),
    darkMode: Yup.boolean().required("تنظیم حالت شب الزامی می باشد"),
});

exports.schemaEditMenuCategory = Yup.object().shape({
    description: Yup.string()
        .required("توضیحات منو الزامی می باشد")
        .min(20, "توضیحات منو نباید کمتر از 20 کاراکتر باشد")
        .max(200, "توضیحات منو نباید بیشتر از 200 کاراکتر باشد"),
});




exports.schemaMenuItem = Yup.object().shape({
    title: Yup.string()
        .required("عنوان آیتم منو الزامی می باشد")
        .min(1, "عنوان آیتم منو نباید کمتر از 1 کاراکتر باشد")
        .max(40, "عنوان آیتم منو نباید بیشتر از 40 کاراکتر باشد"),
    description: Yup.string()
        .max(70, "توضیحات آیتم منو نباید بیشتر از 70 کاراکتر باشد"),
    price: Yup.string().required("قیمت بازی آیتم منو می باشد"),
    discount: Yup.number().required("تخفیف آیتم منو الزامی می باشد").min(0, "حداقل تخفیف 0 درصد می باشد").max(100, "حداکثر تخفیف 100 درصد می باشد"),
    image: Yup.object().shape({
        size: Yup.number().max(500000, "تصویر منو نباید بیشتر از 500 کیلوبایت باشد"), //500KB
        mimetype: Yup.mixed().oneOf(
            ["image/jpeg", "image/png"],
            "تنها پسوندهای png و jpeg پشتیبانی می شوند"
        ),
    }),
    sort: Yup.number().required("مرتب سازی الزامی می باشد"),
    categoryId: Yup.number().required("دسته بندی الزامی می باشد"),
});




exports.schemaMenuNotification = Yup.object().shape({
    title: Yup.string()
        .required("عنوان اطلاعیه الزامی می باشد")
        .min(1, "عنوان اطلاعیه نباید کمتر از 1 کاراکتر باشد")
        .max(40, "عنوان اطلاعیه نباید بیشتر از 40 کاراکتر باشد"),
    text: Yup.string()
        .required("متن اطلاعیه الزامی می باشد")
        .min(1, "متن اطلاعیه نباید کمتر از 1 کاراکتر باشد")
        .max(400, "متن اطلاعیه نباید بیشتر از 400 کاراکتر باشد"),
    status: Yup.mixed().oneOf(
        ["info", "warning", "error", "success"],
        "لطفا یکی از وضعیت ها را انتخاب کنید "
    ),
    menuId: Yup.number().required("انتخاب منو الزامی می باشد"),
});