const { Router } = require("express");
const linkController = require("../../controllers/user/linkController");

const { authenticated, authenticatedLinkUser } = require("../../middlewares/auth");

const router = new Router();


//  @desc GET Link
//  @route  GET /user/links
router.get("/all", authenticated, linkController.getLinks);

//  @desc GET Menus
//  @route  GET /menu/:address
router.get("/:address", authenticated, linkController.getLink);


//  @desc  CREATE LINK
//  @route  POST /user/create-link
router.post("/create", authenticated, linkController.createLink);

//  @desc  EDIT LINK
//  @route  PUT /user/edit-link-profile
router.put("/edit-profile/:address", authenticated, linkController.editProfile);

//  @desc  EDIT LINK
//  @route  PUT /user/edit-link-setting
router.put("/edit-settings/:address", authenticated, linkController.editSettings);

//  @desc  SORT LINK
//  @route  PUT /user/sort-link
router.put("/sort/:id", authenticated, linkController.sortLink);

//  @desc   Check Address Menu
//  @route  PUT /user/check-address-menu
router.post("/check-address", authenticated, linkController.checkAddressLink);



//  @desc  Add Socialmedia
//  @route  POST /user/add-socialmedias
router.post("/block-action", authenticated, linkController.blockAction);

//  @desc  Delete Menu Item
//  @route  DELETE /user/delete-menu-item
router.delete("/delete-block/:id", authenticated, linkController.deleteBlock);


module.exports = router;