const fileUpload = require("express-fileupload");
const express = require("express");
const dotEnv = require("dotenv");

const sequelize = require("./config/db");
const { errorHandler } = require("./middlewares/errors");
const { setHeaders } = require("./middlewares/headers");
const cors = require('cors');


//* Load Config
dotEnv.config({ path: "./config/config.env" });

const app = express();


//* BodyPaser
app.use(setHeaders);

app.use(cors());


app.use(express.urlencoded({
    extended: false,
    limits: {
        fileSize: 500000 //500kb
    }
}));
app.use(express.json());


//* File Upload Middleware
app.use(fileUpload());

//* Static Folder
// app.use(express.static(path.join(__dirname, "public")));

app.use(express.static('public'));


//* Routes
app.use("/", require("./routes/home/home"));

app.use("/user",
    require("./routes/user/account"),
    require("./routes/user/menu"));
app.use("/user/link", require("./routes/user/link"));

app.use("/admin",
    require("./routes/admin/link"),
    require("./routes/admin/menu"),
    require("./routes/admin/user")
);


//* Error Controllers
app.use(errorHandler);

const PORT = process.env.PORT || 3000;


//* Database connection

sequelize
    .sync({ alter: true, force: false })
    .then((result) => {
                console.log(result);
        app.listen(PORT, () => console.log(`The server is running on port ${PORT}`));
    })
    .catch((err) => console.log(err));