const jwt = require("jsonwebtoken");
const Link = require("../models/Link");
const Menu = require("../models/Menu");

exports.authenticated = (req, res, next) => {
    const authHeader = req.get("Authorization");    
    try {
        if (!authHeader) {
            const error = new Error("مجوز کافی ندارید");
            error.statusCode = 401;
            throw error;
        }

        const token = authHeader.split(" ")[1]; //Bearer Token => ['Bearer', token]
        const decodedToken = jwt.verify(token, process.env.JWT_SECRET);

        const expired = Date.now() >= decodedToken.exp * 1000
        if (expired) {
            const error = new Error("مجوز کافی ندارید");
            error.statusCode = 500;
            throw error;
        }
        

        if (!decodedToken) {
            const error = new Error("شما مجوز کافی ندارید");
            error.statusCode = 401;
            throw error;
        }
        req.userId = decodedToken.user.userId;
        next();
    } catch (err) {
        next(err);
    }
};

exports.authenticatedAdmin = (req, res, next) => {
    const authHeader = req.get("Authorization");
    try {
        if (!authHeader) {
            const error = new Error("مجوز کافی ندارید");
            error.statusCode = 401;
            throw error;
        }

        const token = authHeader.split(" ")[1]; //Bearer Token => ['Bearer', token]
        const decodedToken = jwt.verify(token, process.env.JWT_SECRET);

        const expired = Date.now() >= decodedToken.exp * 1000

        if (expired) {
            const error = new Error("مجوز کافی ندارید");
            error.statusCode = 500;
            throw error;
        }

        if (decodedToken.user.level !== "normal") {
            req.userId = decodedToken.user.userId;
            next();
        } else {
            const error = new Error("شما مجوز کافی ندارید");
            error.statusCode = 401;
            throw error;
        }

    } catch (err) {
        next(err);
    }
};

exports.authenticatedGeneralManager = (req, res, next) => {
    const authHeader = req.get("Authorization");
    try {

        if (!authHeader) {
            const error = new Error("مجوز کافی ندارید");
            error.statusCode = 401;
            throw error;
        }

        const token = authHeader.split(" ")[1]; //Bearer Token => ['Bearer', token]
        const decodedToken = jwt.verify(token, process.env.JWT_SECRET);

        const expired = Date.now() >= decodedToken.exp * 1000

        if (expired) {
            const error = new Error("مجوز کافی ندارید");
            error.statusCode = 500;
            throw error;
        }

        if (decodedToken.user.level === "generalManager") {
            req.userId = decodedToken.user.userId;
            next();
        } else {
            const error = new Error("شما مجوز کافی ندارید");
            error.statusCode = 401;
            throw error;
        }

    } catch (err) {
        next(err);
    }
};

exports.authenticatedLinkUser = async (req, res, next) => {
    const linkId = req.body.linkId;
    
    
    try {
        const link = await Link.findOne({ where: { id: linkId } });

        if (!link) {
            const error = new Error("لینک با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        }

        if (link.userId != req.userId) {
            const error = new Error("مجوز کافی ندارید");
            error.statusCode = 401;
            throw error;
        } else {
            next();
        }
    } catch (err) {
        next(err);
    }
};

exports.authenticatedMenuUser = async (req, res, next) => {
    const menuId = req.body.menuId;

    try {
        const menu = await Menu.findOne({ where: { id: menuId } });

        if (!menu) {
            const error = new Error("منو با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        }

        if (menu.userId != req.userId) {
            const error = new Error("مجوز کافی ندارید");
            error.statusCode = 401;
            throw error;
        } else {
            next();
        }
    } catch (err) {
        next(err);
    }
};
