const { DataTypes } = require("sequelize");
const sequelize = require("../config/db");

const Block = require("./Block");

const Description = sequelize.define("Description", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    text: {
        type: DataTypes.STRING("800"),
        allowNull: false,
    },
    fontsize: {
        type: DataTypes.ENUM("1", "2", "3"),
        allowNull: false,
        defaultValue: "2",
    },
    align: {
        type: DataTypes.ENUM("1", "2", "3" , "4"),
        allowNull: false,
        defaultValue: "1",
    },
    sort: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    blockId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Block,
            key: "id"
        }
    },
});

Description.belongsTo(Block, { as: 'blocks', foreignKey: "blockId" })
Block.hasMany(Description, { as: 'descriptions', foreignKey: "blockId" })

module.exports = Description;