const { DataTypes } = require("sequelize");
const sequelize = require("../config/db");
const Separator = require("./Separator");
const Link = require("./Link");
const Block = require("./Block");


const L_Separator = sequelize.define("L_Separator", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    sort: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    separatorId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Separator,
            key: "id"
        }
    },
    blockId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Block,
            key: "id"
        }
    },
});


Separator.hasMany(L_Separator, { foreignKey: "separatorId", as: "blocks" });
Block.hasMany(L_Separator, { foreignKey: "blockId", as: "separators" });

L_Separator.belongsTo(Separator, { foreignKey: "separatorId", as: "data" });
L_Separator.belongsTo(Block, { foreignKey: "blockId", as: "block" });


module.exports = L_Separator;
