const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Link = require("./Link");
const Block = require("./Block");

const LinksAddress = sequelize.define("LinksAddress", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING("40"),
        allowNull: false,
    },
    url: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    sort: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    blockId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Block,
            key: "id"
        }
    },
});

LinksAddress.belongsTo(Block, { as: 'blocks', foreignKey: "blockId" })
Block.hasMany(LinksAddress, { as: 'linksAddress', foreignKey: "blockId" })



module.exports = LinksAddress;