const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");

const MenuPlan = sequelize.define("MenuPlan", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING("40"),
        allowNull: false,
    },
    day: {
        type: DataTypes.INTEGER("999"),
        allowNull: false,
    },
    price: {
        type: DataTypes.INTEGER("999999999"),
        allowNull: false,
    },
    discount: {
        type: DataTypes.INTEGER("100"),
        allowNull: false,
    },
    publish: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    }
});


module.exports = MenuPlan;