const Yup = require("yup");

exports.schemaBanner = Yup.object().shape({
    linkId: Yup.string().required("لینک جدید باید دارای لینک مرتبط باشد"),
    image: Yup.object().shape({
        name: Yup.string().required("عکس الزامی می باشد"),
        size: Yup.number().max(500000, "عکس نباید بیشتر از 500 کیلوبایت باشد"), //500KB
        mimetype: Yup.mixed().oneOf(
            ["image/jpeg", "image/jpeg", "image/png"],
            "تنها پسوندهای png و jpg و jpeg پشتیبانی می شوند"
        ),
    }),
});
