const { Router } = require("express");

const linkController = require("../../controllers/admin/linkController");

const { authenticatedGeneralManager } = require("../../middlewares/auth");

const router = new Router();




// *** START linkController ***

//  @desc  GET Socialmedia
//  @route  GET /socialmedias
router.get("/socialmedias", authenticatedGeneralManager, linkController.getSocialmedias);

//  @desc   Admin Handle Get Socialmedia
//  @route  GET /admin/socialmedia/:id
router.get("/socialmedia/:id", authenticatedGeneralManager, linkController.getSocialmedia);

//  @desc  CREATE Socialmedia
//  @route  POST /create-socialmedias
router.post("/create-socialmedia", authenticatedGeneralManager, linkController.createSocialmedias);

//  @desc  PUT Socialmedia
//  @route  PUT /edit-socialmedias
router.put("/edit-socialmedia/:id", authenticatedGeneralManager, linkController.editSocialmedias);

//  @desc  DELETE Socialmedia
//  @route  DELETE /delete-socialmedias
router.delete("/delete-socialmedia/:id", authenticatedGeneralManager, linkController.deleteSocialmedias);



//  @desc  GET Separator
//  @route  GET /separators
router.get("/separators", authenticatedGeneralManager, linkController.getSeparators);

//  @desc   Admin Handle Get separators
//  @route  GET /admin/separator/:id
router.get("/separator/:id", authenticatedGeneralManager, linkController.getSeparator);

//  @desc  CREATE Separator
//  @route  POST /create-separators
router.post("/create-separator", authenticatedGeneralManager, linkController.createSeparators);

//  @desc  PUT Separator
//  @route  PUT /edit-separators
router.put("/edit-separator/:id", authenticatedGeneralManager, linkController.editSeparators);

//  @desc  DELETE Separator
//  @route  DELETE /delete-separators
router.delete("/delete-separator/:id", authenticatedGeneralManager, linkController.deleteSeparators);



//  @desc  GET Contact
//  @route  GET /contacts
router.get("/contacts", authenticatedGeneralManager, linkController.getContacts);

//  @desc  Admin Handle Get Contact
//  @route  GET /admin/Contact/:id
router.get("/contact/:id", authenticatedGeneralManager, linkController.getContact);

//  @desc  CREATE Contact
//  @route  POST /create-contacts
router.post("/create-contact", authenticatedGeneralManager, linkController.createContacts);

//  @desc  PUT Contact
//  @route  PUT /edit-contacts
router.put("/edit-contact/:id", authenticatedGeneralManager, linkController.editContacts);

//  @desc  DELETE Contact
//  @route  DELETE /delete-contacts
router.delete("/delete-contact/:id", authenticatedGeneralManager, linkController.deleteContacts);

// *** END linkController ***


module.exports = router;
