const Separator = require("../../models/Separator");
const Socialmedia = require("../../models/Socialmedia");
const Contact = require("../../models/Contact");
const L_S = require("../../models/L_S");
const L_Separator = require("../../models/L_Separator");
const L_C = require("../../models/L_C");

const { schemaSocialmedias } = require("../../models/secure/socialmediasValidation");
const { schemaSeparators } = require("../../models/secure/separatorsValidation");
const { schemaContacts } = require("../../models/secure/contactsValidation");




// Socialmedia
exports.getSocialmedias = async (req, res, next) => {
    const page = +req.query.page || 1;
    const limit = +req.query.size || 8;
    const offset = (page - 1) * limit;

    try {
        const items = await Socialmedia.findAll({
            limit,
            offset,
            order: [
                ['id', 'DESC']
            ]
        });

        if (items.length == 0) {
            const error = new Error("هیچ شبکه اجتماعی ثبت نشده است");
            error.statusCode = 404;
            throw error;
        }

        const count = await Socialmedia.count();
        const infoPage = {
            currentPage: page,
            nextPage: page + 1,
            previousPage: page - 1,
            hasNextPage: limit * page < count,
            hasPreviousPage: page > 1,
            pagesCount: Math.ceil(count / limit),
        }

        res.status(200).json({ items: items, count, infoPage });
    } catch (err) {
        next(err);
    }
};

exports.getSocialmedia = async (req, res, next) => {
    try {
        const item = await Socialmedia.findByPk(req.params.id);
        if (!item) {
            const error = new Error("شبکه اجتماعی با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        }
        res.status(200).json(item);
    } catch (err) {
        next(err);
    }
};

exports.createSocialmedias = async (req, res, next) => {
    try {
        await schemaSocialmedias.validate(req.body, { abortEarly: false });
        await Socialmedia.create(req.body);
        res.status(201).json({ message: "شبکه اجتماعی جدید با موفقیت ساخته شد" });
    } catch (err) {
        next(err);
    }
};

exports.editSocialmedias = async (req, res, next) => {
    const item = await Socialmedia.findByPk(req.params.id);
    try {
        if (!item) {
            const error = new Error("شبکه اجتماعی با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        } else {
            await schemaSocialmedias.validate(req.body, { abortEarly: false });
            const { title, svg, color } = req.body;
            item.title = title;
            item.svg = svg;
            item.color = color;
            await item.save();
            res.status(200).json({ message: "شبکه اجتماعی با موفقیت ویرایش شد" });
        }
    } catch (err) {
        next(err);
    }
};

exports.deleteSocialmedias = async (req, res, next) => {
    try {
        const item = await Socialmedia.findByPk(req.params.id);
        if (!item) {
            const error = new Error(" شبکه اجتماعی با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        } else {
            await L_S.destroy({ where: { socialmediaId: req.params.id } });
            await Socialmedia.destroy({ where: { id: req.params.id } });
        }
        res.status(200).json({ message: "شبکه اجتماعی با موفقیت پاک شد" });
    } catch (err) {
        next(err);
    }
};




// Separator
exports.getSeparators = async (req, res, next) => {
    const page = +req.query.page || 1;
    const limit = +req.query.size || 8;
    const offset = (page - 1) * limit;

    try {
        const items = await Separator.findAll({
            limit,
            offset,
            order: [
                ['id', 'DESC']
            ]
        });

        if (items.length == 0) {
            const error = new Error("هیچ جداکننده ای در پایگاه داده ثبت نشده است");
            error.statusCode = 404;
            throw error;
        }

        const count = await Separator.count();
        const infoPage = {
            currentPage: page,
            nextPage: page + 1,
            previousPage: page - 1,
            hasNextPage: limit * page < count,
            hasPreviousPage: page > 1,
            pagesCount: Math.ceil(count / limit),
        }

        res.status(200).json({ items: items, count, infoPage });
    } catch (err) {
        next(err);
    }
};

exports.getSeparator = async (req, res, next) => {
    try {
        const item = await Separator.findByPk(req.params.id);
        if (!item) {
            const error = new Error("جدا کننده ای با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        }
        res.status(200).json(item);
    } catch (err) {
        next(err);
    }
};

exports.createSeparators = async (req, res, next) => {
    try {
        await schemaSeparators.validate(req.body, { abortEarly: false });
        await Separator.create(req.body);
        res.status(201).json({ message: "جداکننده جدید با موفقیت ساخته شد" });
    } catch (err) {
        next(err);
    }
};

exports.editSeparators = async (req, res, next) => {
    const item = await Separator.findByPk(req.params.id);
    try {
        if (!item) {
            const error = new Error("جداکننده با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        } else {
            await schemaSeparators.validate(req.body, { abortEarly: false });
            const { title, svg } = req.body;
            item.title = title;
            item.svg = svg;
            await item.save();
            res.status(200).json({ message: "جداکننده با موفقیت ویرایش شد" });
        }
    } catch (err) {
        next(err);
    }
};

exports.deleteSeparators = async (req, res, next) => {
    try {
        const item = await Separator.findByPk(req.params.id);
        if (!item) {
            const error = new Error(" جداکننده با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        } else {
            await L_Separator.destroy({ where: { separatorId: req.params.id } });
            await Separator.destroy({ where: { id: req.params.id } });
        }
        res.status(200).json({ message: "جداکننده با موفقیت پاک شد" });
    } catch (err) {
        next(err);
    }
};





// Contact
exports.getContacts = async (req, res, next) => {
    const page = +req.query.page || 1;
    const limit = +req.query.size || 8;
    const offset = (page - 1) * limit;

    try {
        const items = await Contact.findAll({
            limit,
            offset,
            order: [
                ['id', 'DESC']
            ]
        });

        if (items.length == 0) {
            const error = new Error("هیچ راه ارتباطی در پایگاه داده ثبت نشده است");
            error.statusCode = 404;
            throw error;
        }

        const count = await Contact.count();
        const infoPage = {
            currentPage: page,
            nextPage: page + 1,
            previousPage: page - 1,
            hasNextPage: limit * page < count,
            hasPreviousPage: page > 1,
            pagesCount: Math.ceil(count / limit),
        }

        res.status(200).json({ items: items, count, infoPage });
    } catch (err) {
        next(err);
    }
};

exports.getContact = async (req, res, next) => {
    try {
        const item = await Contact.findByPk(req.params.id);
        if (!item) {
            const error = new Error("راه ارتباطی ای با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        }
        res.status(200).json(item);
    } catch (err) {
        next(err);
    }
};

exports.createContacts = async (req, res, next) => {
    try {
        await schemaContacts.validate(req.body, { abortEarly: false });
        await Contact.create(req.body);
        res.status(201).json({ message: "راه ارتباطی جدید با موفقیت ساخته شد" });
    } catch (err) {
        next(err);
    }
};

exports.editContacts = async (req, res, next) => {
    const item = await Contact.findByPk(req.params.id);
    try {
        if (!item) {
            const error = new Error("راه ارتباطی با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        } else {
            await schemaContacts.validate(req.body, { abortEarly: false });
            const { title, svg, color } = req.body;
            item.title = title;
            item.svg = svg;
            item.color = color;
            await item.save();
            res.status(200).json({ message: "راه ارتباطی با موفقیت ویرایش شد" });
        }
    } catch (err) {
        next(err);
    }
};

exports.deleteContacts = async (req, res, next) => {
    try {
        const item = await Contact.findByPk(req.params.id);
        if (!item) {
            const error = new Error("راه ارتباطی با این شناسه یافت نشد");
            error.statusCode = 404;
            throw error;
        } else {
            await L_C.destroy({ where: { contactId: req.params.id } });
            await Contact.destroy({ where: { id: req.params.id } });
        }
        res.status(200).json({ message: "راه ارتباطی با موفقیت پاک شد" });
    } catch (err) {
        next(err);
    }
};


