const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Link = require("./Link");
const Block = require("./Block");

const Question = sequelize.define("Question", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    question: {
        type: DataTypes.STRING("60"),
        allowNull: false,
    },
    answer: {
        type: DataTypes.STRING,
        allowNull: false
    },
    sort: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    blockId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Block,
            key: "id"
        }
    },
});

Question.belongsTo(Block, { as: 'blocks', foreignKey: "blockId" })
Block.hasMany(Question, { as: 'questions', foreignKey: "blockId" })



module.exports = Question;