const Yup = require("yup");

exports.schemaLink = Yup.object().shape({
    address: Yup.string().required("لینک جدید باید دارای آدرس باشد"),
    title: Yup.string().required("عنوان الزامی می باشد"),
    description: Yup.string()
        .max(60, "توضیحات لینک نباید بیشتر از 60 کاراکتر باشد"),
    profile: Yup.object().shape({
        name: Yup.string().required("عکس پروفایل الزامی می باشد"),
        size: Yup.number().max(500000, "عکس نباید بیشتر از 500 کیلوبایت باشد"), //500KB
        mimetype: Yup.mixed().oneOf(
            ["image/jpeg", "image/png"],
            "تنها پسوندهای png و jpeg پشتیبانی می شوند"
        ),
    }),
    thumbnail: Yup.object().shape({
        name: Yup.string(),
        size: Yup.number().max(500000, "عکس نباید بیشتر از 500 کیلوبایت باشد"), //500KB
        mimetype: Yup.mixed().oneOf(
            ["image/jpeg", "image/png"],
            "تنها پسوندهای png و jpeg پشتیبانی می شوند"
        ),
    })
});

exports.schemaBlock = Yup.object().shape({
    title: Yup.string()
        .max(60, "عنوان نباید بیشتر از 60 کاراکتر باشد"),
    colorType: Yup.mixed().oneOf(
        ["1", "2", "3"],
        "لطفا یکی از وضعیت های (1، 2، 3) را انتخاب کنید "
    ),
    radiusType: Yup.mixed().oneOf(
        ["1", "2"],
        "لطفا یکی از وضعیت های (1، 2) را انتخاب کنید "
    ),
    widthType: Yup.mixed().oneOf(
        ["1", "2", "3", "4"],
        "لطفا یکی از وضعیت های (1، 2، 3، 4) را انتخاب کنید "
    ),
    type: Yup.mixed().required("نوع بلوک الزامی می باشد").oneOf(
        ["socialmedia", "contact", "separator", "banner", "description", "linksAddress", "question"],
        "لطفا یکی از وضعیت های مورد نظر را انتخاب کنید "
    ),
    bg: Yup.string("پس زمینه نادرست است"),
    color: Yup.string("رنگ نادرست است"),
    coloBorder: Yup.string("رنگ حاشیه نادرست است"),
    radius: Yup.mixed().oneOf(
        ["1", "2", "3", "4"],
        "لطفا یکی از وضعیت های (1، 2، 3، 4) را انتخاب کنید "
    ),
    sort: Yup.number().required("مرتب سازی الزامی می باشد"),
    isActive: Yup.boolean("یکی از 2 وضعیت (روشن، خاموش) را انتخاب کنید"),
    linkId: Yup.number().required("انتخاب لینک الزامی می باشد"),
});

exports.schemaSocialmedia = Yup.object().shape({
    title: Yup.string().required("عنوان الزامی می باشد"),
    address: Yup.string().required("وارد کردن آدرس الزامی میباشد"),
    sort: Yup.number().required("مرتب سازی الزامی می باشد"),
});

exports.schemaContact = Yup.object().shape({
    title: Yup.string().required("عنوان الزامی می باشد"),
    address: Yup.string().required("وارد کردن آدرس الزامی میباشد"),
    sort: Yup.number().required("مرتب سازی الزامی می باشد"),
});

exports.schemaSeparator = Yup.object().shape({
    sort: Yup.number().required("مرتب سازی الزامی می باشد"),
});

exports.schemaBanner = Yup.object().shape({
    image: Yup.object().shape({
        name: Yup.string().required("عکس الزامی می باشد"),
        size: Yup.number().max(500000, "عکس نباید بیشتر از 500 کیلوبایت باشد"), //500KB
        mimetype: Yup.mixed().oneOf(
            ["image/jpeg", "image/jpeg", "image/png"],
            "تنها پسوندهای png و jpg و jpeg پشتیبانی می شوند"
        ),
    }),
    url: Yup.string("آدرس اینترنتی نادرست است"),
    sort: Yup.number().required("مرتب سازی الزامی می باشد"),
});

exports.schemaDescription = Yup.object().shape({
    text: Yup.string().required("وارد کردن توضیحات الزامی می باشد"),
    fontsize: Yup.mixed().oneOf(
        ["1", "2", "3"],
        "لطفا یکی از وضعیت های (1، 2، 3) را انتخاب کنید "
    ),
    align: Yup.mixed().oneOf(
        ["1", "2", "3", "4"],
        "لطفا یکی از وضعیت های (1، 2، 3) را انتخاب کنید "
    ),
    sort: Yup.number().required("مرتب سازی الزامی می باشد"),
});

exports.schemaLinkAddress = Yup.object().shape({
    title: Yup.string().required("عنوان الزامی می باشد"),
    url: Yup.string().required("آدرس اینترنتی الزامی می باشد"),
    sort: Yup.number().required("مرتب سازی الزامی می باشد"),
});

exports.schemaQuestion = Yup.object().shape({
    question: Yup.string().required("سوال الزامی می باشد"),
    answer: Yup.string().required("پاسخ الزامی می باشد"),
    sort: Yup.number().required("مرتب سازی الزامی می باشد"),
});

